﻿//////////////////////////////////////////////
// DdsDxt10Header.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Enums/DdsAlphaMode.h"
#include "../Enums/DdsDxgiFormat.h"
#include "../Enums/DdsResourceDimension.h"
#include "../Enums/DdsResourceMiscFlag.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages::dds
{
	class DdsDxt10Header final
	{
		public :

			// Functions
			// Encode
			void encodeInData (nkMemory::BufferView<unsigned char> data) const ;
			// Decode
			void decodeFromData (nkMemory::BufferView<unsigned char> data) ;

		public :

			// Attributes
			DDS_DXGI_FORMAT _format = DDS_DXGI_FORMAT::DDS_DXGI_FORMAT_UNKNOWN ;
			DDS_RESOURCE_DIMENSION _dimension = DDS_RESOURCE_DIMENSION::DDS_RESOURCE_DIMENSION_UNKNOWN ;
			DDS_RESOURCE_MISC_FLAG _miscFlags = DDS_RESOURCE_MISC_FLAG::DDS_RESOURCE_MISC_FLAG_UNKNOWN ;

			unsigned int _arraySize = 0 ;

			DDS_ALPHA_MODE _alphaMode = DDS_ALPHA_MODE::DDS_ALPHA_MODE_UNKNOWN ;
	} ;
}